/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.providers.AbstractSampler;
import se.hirt.greychart.util.ChartRenderingToolkit;

public final class AveragingSampleBuffer
extends AbstractSampler {
    private double previousX = Double.NaN;
    private double previousY = Double.NaN;

    public AveragingSampleBuffer(int size) {
        super(size);
    }

    public void addDataPoint(double normalizedX, double currentY) {
        if (normalizedX < 0.0 || normalizedX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedX);
        }
        this.addSamplePoint((double)this.getSize() * normalizedX, currentY);
    }

    private void addSamplePoint(double currentX, double currentY) {
        if (Double.isNaN(this.previousX)) {
            this.previousX = (int)ChartRenderingToolkit.fastFloor(currentX);
            this.previousY = currentY;
        }
        if (currentX > this.previousX) {
            this.addBucketSample(currentX, currentY);
        }
        this.previousX = currentX;
        this.previousY = currentY;
    }

    private void addBucketSample(double currentX, double currentY) {
        int currentBucket;
        double k = (currentY - this.previousY) / (currentX - this.previousX);
        int prevBucket = this.getIndex(this.previousX);
        if (prevBucket != (currentBucket = Math.min(this.getIndex(currentX), this.getSize() - 1))) {
            this.addSegmentToBucket(prevBucket, this.previousY, k, (double)(prevBucket + 1) - this.previousX);
            this.addSegmentToBucket(currentBucket, currentY, -k, currentX - (double)currentBucket);
        } else {
            this.addSegmentToBucket(prevBucket, this.previousY, k, currentX - this.previousX);
        }
    }

    private void addSegmentToBucket(int bucketIndex, double segmentHeigth, double segmentGradient, double segmentWidth) {
        double segmentArea = (segmentHeigth + segmentGradient * segmentWidth / 2.0) * segmentWidth;
        this.getSamplePoint((int)bucketIndex).y += segmentArea;
    }

    public void fixSamples() {
        int lastIndex = this.getIndex(this.previousX);
        if (lastIndex < this.getSize()) {
            this.addSegmentToBucket(lastIndex, this.previousY, 0.0, (double)(lastIndex + 1) - this.previousX);
        }
        this.invalidateStatistics();
    }
}

