/**
 * 字符串`末尾`添加`/`
 */
export function addTrailingSlash(path) {
    return path.endsWith("/") ? path : path + "/";
}
/**
 * 删除特定`开头`的`字符串`
 */
export function removeHeadingString(path, heading) {
    return path.startsWith(heading) ? path.slice(heading.length) : path;
}
/**
 * 删除字符串`开头`的`/`
 */
export function removeHeadingSlash(path) {
    return removeHeadingString(path, "/");
}
/**
 * 去除字符串中的 HTML 标签
 */
export function stripHtmlTags(input, maxLength) {
    const strippedText = input.replace(/<[^>]*>/g, "");
    if (strippedText.length > maxLength) {
        return strippedText.substring(0, maxLength) + "...";
    }
    return strippedText;
}
