declare global {
    /**
     * 声明映射关系
     */
    interface EventMapper {
    }
}
/**
 * 事件名称
 */
export type EventName = keyof EventMapper;
/**
 * 事件参数
 */
export type EventArgument<T extends EventName> = EventMapper[T];
export declare class EventBus {
    private emitter;
    private bufferMap;
    private getBufferValue;
    private setBufferValue;
    /**
     * 监听事件
     */
    on<N extends EventName, A extends EventArgument<N>>(event: N, callback: (arg: A) => void): () => void;
    /**
     * 监听一次事件
     */
    once<N extends EventName, A extends EventArgument<N>>(event: N, callback: (arg: A) => void): () => void;
    /**
     * 触发事件
     * @param event
     * @param arg
     * @param replay - 是否重放该值
     */
    emit<N extends EventName, A extends EventArgument<N>>(event: N, arg: A, replay?: boolean): void;
    /**
     * 需要最新值的时候 可以调用此方法重置
     */
    resetReplayValue<N extends EventName>(event: N): void;
    /**
     * 监听新的订阅者
     */
    onSubscriber<N extends EventName, A extends EventArgument<N>>(event: N, callback: (listener: (arg: A) => void) => void): () => void;
}
//# sourceMappingURL=eventBus.d.ts.map