"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripHtmlTags = exports.removeHeadingSlash = exports.removeHeadingString = exports.addTrailingSlash = void 0;
/**
 * 字符串`末尾`添加`/`
 */
function addTrailingSlash(path) {
    return path.endsWith("/") ? path : path + "/";
}
exports.addTrailingSlash = addTrailingSlash;
/**
 * 删除特定`开头`的`字符串`
 */
function removeHeadingString(path, heading) {
    return path.startsWith(heading) ? path.slice(heading.length) : path;
}
exports.removeHeadingString = removeHeadingString;
/**
 * 删除字符串`开头`的`/`
 */
function removeHeadingSlash(path) {
    return removeHeadingString(path, "/");
}
exports.removeHeadingSlash = removeHeadingSlash;
/**
 * 去除字符串中的 HTML 标签
 */
function stripHtmlTags(input, maxLength) {
    const strippedText = input.replace(/<[^>]*>/g, "");
    if (strippedText.length > maxLength) {
        return strippedText.substring(0, maxLength) + "...";
    }
    return strippedText;
}
exports.stripHtmlTags = stripHtmlTags;
