import { DageRequestConfig, DageRequestMethod } from "./types";
/**
 * 转换 Headers 为 对象形式
 * @param headers
 */
export declare function headersToObject(headers: Headers): Record<string, string>;
/**
 * 能携带参数的请求方法
 * @param method
 */
export declare function methodsHasBody(method: DageRequestMethod): boolean;
/**
 * 序列化载荷
 * @param headers
 * @param body
 */
export declare function serializeBody(headers: Record<string, string>, body: any): any;
export declare function isFormData(value: any): boolean;
export declare function isBlob(value: any): boolean;
export declare function isArrayBuffer(value: any): boolean;
/**
 * 根据body生成对应的contentType
 * @param body http body
 */
export declare function detectContentType(body: any): string | null;
export declare function getResponseType(config: DageRequestConfig): DageRequestMeta["responseType"];
export declare function serializeResponseBody(res: globalThis.Response, config: DageRequestConfig): Promise<Record<string, any> & {
    data: any;
}>;
//# sourceMappingURL=utils.d.ts.map