declare global {
    /**
     * 接口请求元数据，由应用自行定义，可以在 拦截器中获取
     */
    interface DageRequestMeta {
        /**
         * 响应正文格式
         * 默认为 `json`
         */
        responseType?: "text" | "arrayBuffer" | "blob" | "json";
    }
}
/**
 * 规范化
 */
export interface CommonResponse<T = any> {
    data: T;
    code: number;
    errorCode?: number;
    errorMessage?: string;
    /**
     * 原始响应
     */
    __raw__: {
        data: any;
        statusCode: number;
        header: Record<string, string>;
    };
}
/**
 * 响应对象
 */
export interface DageResponse<T = any> extends CommonResponse<T> {
}
export interface DageRequest extends Required<DageRequestConfig> {
    name: string;
    body: Record<string, any>;
}
export type DageRequestMethod = "GET" | "POST" | "DELETE" | "PUT" | "PATCH" | "HEAD";
export interface DageRequestConfig {
    /**
     * 默认为 POST
     */
    method?: DageRequestMethod;
    /**
     * 查询字符串
     */
    searchParams?: Record<string, string>;
    /**
     * 报头
     */
    headers?: Record<string, string>;
    /**
     * 自定义元数据, 可以用于拦截
     */
    meta?: DageRequestMeta;
}
/**
 * 拦截器，可以修改 request 对象，调用 next 发起请求
 */
export type Interceptor = (request: DageRequest, next: () => Promise<DageResponse | PaginationResponse>) => Promise<DageResponse | PaginationResponse>;
export interface PaginationResponse<T = any> extends CommonResponse<T[]> {
    total: number;
    size: number;
    pages: number;
}
export interface PaginationParams {
    pageSize: number;
    pageNum: number;
}
//# sourceMappingURL=types.d.ts.map