import { DageRequestConfig, DageResponse, Interceptor, PaginationParams, PaginationResponse } from "./types";
export interface ServiceAdapter {
    baseURL: string;
    fetch: typeof fetch;
    /**
     * 拦截器
     */
    interceptor?: Interceptor;
    /**
     * 全局变量
     */
    globalVariables?: Record<string, any>;
}
export declare function createService(): {
    getBaseURL: () => string;
    parseResponse: (response: DageResponse | PaginationResponse) => DageResponse | PaginationResponse;
    initial: (options: ServiceAdapter) => void;
    isInitialized: () => boolean;
    request: <R = any, P extends {} = any>(url: string, body?: P | undefined, config?: DageRequestConfig) => Promise<R>;
    requestByPost: <R = any, P extends {} = any>(url: string, body?: P | undefined, config?: DageRequestConfig) => Promise<R>;
    requestByGet: <R_1 = any, P_1 extends {} = any>(url: string, body?: P_1 | undefined, config?: DageRequestConfig) => Promise<R_1>;
    requestPagination: <R_2 = any, P_2 extends PaginationParams = any>(name: string, body?: P_2 | undefined, config?: DageRequestConfig) => Promise<PaginationResponse<R_2>>;
};
/**
 * 获取 Base URL
 * @returns
 */
export declare const getBaseURL: () => string;
/**
 * 解析响应
 * @param response
 * @returns
 */
export declare const parseResponse: (response: DageResponse | PaginationResponse) => DageResponse | PaginationResponse;
/**
 * 是否初始化完成
 * @returns
 */
export declare const isInitialized: () => boolean;
/**
 * 初始化
 * @param options
 */
export declare const initial: (options: ServiceAdapter) => void;
export declare const request: <R = any, P extends {} = any>(url: string, body?: P | undefined, config?: DageRequestConfig) => Promise<R>;
export declare const requestByPost: <R = any, P extends {} = any>(url: string, body?: P | undefined, config?: DageRequestConfig) => Promise<R>;
export declare const requestByGet: <R = any, P extends {} = any>(url: string, body?: P | undefined, config?: DageRequestConfig) => Promise<R>;
export declare const requestPagination: <R = any, P extends PaginationParams = any>(name: string, body?: P | undefined, config?: DageRequestConfig) => Promise<PaginationResponse<R>>;
//# sourceMappingURL=request.d.ts.map