/**
 * 响应错误对象
 */
export class ResponseError extends Error {
    constructor(response) {
        var _a, _b;
        super((_a = response.errorMessage) !== null && _a !== void 0 ? _a : "请求失败");
        this.code = (_b = response.errorCode) !== null && _b !== void 0 ? _b : -1;
        this.response = response;
    }
}
/**
 * 判断错误对象是否为响应错误对象。 用于 catch 语句安全地获取 code 和 message
 * @param error
 * @returns
 */
export function isResponseError(error) {
    return !!(error &&
        typeof error === "object" &&
        "code" in error &&
        "message" in error);
}
