function transformKey(key) {
    return typeof key === "symbol" ? key : key.toLowerCase();
}
/**
 * HTTP 报头比较特殊，需要兼容不同的大小写的 key
 */
export function createHeader() {
    const headers = Object.create(null);
    return new Proxy(headers, {
        set(target, key, value) {
            return Reflect.set(target, transformKey(key), value);
        },
        get(target, key) {
            return Reflect.get(target, transformKey(key));
        },
        has(target, key) {
            return Reflect.has(target, transformKey(key));
        },
        deleteProperty(target, key) {
            return Reflect.deleteProperty(target, transformKey(key));
        },
    });
}
