import { __awaiter } from "tslib";
/**
 * 文件下载并获取下载进度
 */
export const requestWithPercent = ({ url = "", option = {}, onProcess, }) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const res = yield fetch(url, Object.assign({ mode: "cors", headers: {
            responseType: "arraybuffer",
            Accept: "application/json, text/plain, */*",
            "Cache-Control": "no-cache",
        } }, option));
    const reader = (_a = res.body) === null || _a === void 0 ? void 0 : _a.getReader();
    /** 文件总长度 */
    const contentLength = Number(res.headers.get("content-length"));
    const chunks = [];
    let receivedLength = 0;
    if (!reader)
        return Promise.reject(new Error("无法解析请求体"));
    while (true) {
        const { done, value } = yield reader.read();
        if (done) {
            break;
        }
        chunks.push(value);
        receivedLength += value.length;
        onProcess(receivedLength, contentLength);
    }
    const chunksAll = new Uint8Array(receivedLength);
    let position = 0;
    for (const chunk of chunks) {
        chunksAll.set(chunk, position);
        position += chunk.length;
    }
    return chunksAll;
});
