import { UploadFile, UploadProps } from "antd";
export declare enum DageUploadType {
    /** 缩略图 */
    THUMB = "thumb",
    /** PC 模型 */
    MODEL = "model",
    /** Mobile 模型 */
    MOBILE_MODEL = "model_mobile",
    /** 视频 */
    VIDEO = "video",
    /** 图片 */
    IMG = "img",
    /** 音频 */
    AUDIO = "audio",
    /** 文档 */
    DOC = "doc"
}
export interface DageFileResponseType<T = DageFileAPIResponseType> extends UploadFile<T> {
    dType: DageUploadType;
    imgAttrs?: {
        width: number;
        height: number;
    };
}
export interface DageUploadProps<T = DageFileAPIResponseType> extends Pick<UploadProps<T>, "customRequest" | "directory" | "maxCount" | "disabled" | "onDrop" | "onDownload" | "onRemove" | "headers" | "data" | "name" | "className" | "children"> {
    /**
     * 上传地址
     */
    action: string;
    /**
     * 已经上传的文件列表
     */
    value?: DageFileResponseType<T>[];
    /**
     * 最大尺寸（M）
     * @default 5
     */
    maxSize?: number;
    /**
     * 接口参数-文件类型
     * @default DageUploadType.IMG
     */
    dType?: DageUploadType;
    /**
     * 提示语
     */
    tips?: string;
    /**
     * 下载报错提示语
     * @default 下载失败
     */
    downloadErrorMessage?: string;
    /**
     * 上传文件改变时的回调
     */
    onChange?(list: DageFileResponseType[], file: DageFileResponseType): void;
}
/**
 * 接口返回文件类型
 */
export type DageFileAPIResponseType = {
    id: number;
    fileName: string;
    filePath: string;
    moduleName: string;
    type: DageUploadType;
};
export type HandleUploadingFileNumType = "add" | "uploaded";
//# sourceMappingURL=types.d.ts.map