import { CloseOutlined } from "@ant-design/icons";
import { Upload } from "antd";
import { css, keyframes, styled } from "styled-components";
const { Dragger } = Upload;
export const UploadTips = styled.p `
  color: #999999;
  font-size: 12px;
`;
export const UploadContainer = styled.div.attrs({
    className: "dage-upload",
}) `
  display: inline-block;
  min-width: 320px;
`;
const uploadStyle = css `
  .ant-btn:has(.hide) {
    display: none;
  }
`;
export const AntdUpload = styled(Upload) `
  ${uploadStyle}
`;
export const AntdDragger = styled(Dragger) `
  ${uploadStyle}
`;
export const AntdDraggerText = styled.p `
  margin: 14px 0;
`;
export const UploadFileItem = styled.div `
  display: flex;
  align-items: center;
  position: relative;
  margin-top: 8px;
  height: 24px;
  border-radius: 4px;
  transition: all 0.3s;

  &:hover {
    background-color: rgba(0, 0, 0, 0.04);
  }
  ${({ $showDownloadProgress }) => $showDownloadProgress &&
    css `
      margin-bottom: 10px;
    `}
  .ant-upload-list-item {
    flex: 1;
    width: 0;
    height: 100% !important;
    margin: 0 !important;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;

    &:hover {
      background: none !important;
    }
  }
`;
export const UploadFileItemActions = styled.div `
  display: none;
  white-space: nowrap;

  ${UploadFileItem}:hover & {
    display: block;
  }
  .ant-btn {
    color: #666;
  }
`;
export const UploadPictureItem = styled.div `
  position: relative;
  height: 100%;

  &:hover::before {
    opacity: 1;
  }
  &::before {
    position: absolute;
    top: 8px;
    left: 8px;
    z-index: 1;
    width: calc(100% - 16px);
    height: calc(100% - 16px);
    background-color: rgba(0, 0, 0, 0.45);
    opacity: 0;
    transition: all 0.3s;
    content: " ";
  }
  .ant-upload-list-item::before {
    display: none;
  }
`;
export const UploadPictureItemActions = styled.div `
  display: none;
  position: absolute;
  top: 50%;
  left: 50%;
  white-space: nowrap;
  transform: translate(-50%, -50%);
  z-index: 2;

  ${UploadPictureItem}:hover & {
    display: block;
  }
  .ant-btn {
    color: rgba(255, 255, 255, 0.65);

    &:hover {
      color: white !important;
    }
  }
`;
const fadeInAnimation = keyframes `
  0% { opacity: 0; }
  100% { opacity: 1; }
`;
export const DownloadProgress = styled.div `
  display: flex;
  align-items: center;
  position: absolute;
  left: 0;
  right: 0;
  bottom: -15px;
  animation: ${fadeInAnimation} 0.2s ease-in-out;
`;
export const DownloadCancelBtn = styled(CloseOutlined) `
  position: relative;
  top: 2px;
  margin-left: 5px;
  color: #999;
  cursor: pointer;
`;
