import { __awaiter } from "tslib";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo, useRef, useState } from "react";
import { DeleteOutlined, DownloadOutlined, EyeOutlined, } from "@ant-design/icons";
import { Button, Progress, message } from "antd";
import { DownloadCancelBtn, DownloadProgress, UploadFileItem, UploadFileItemActions, UploadPictureItem, UploadPictureItemActions, } from "./style";
import { requestWithPercent } from "../../utils";
export const DageUploadItemActions = ({ children, disabled, file, isPictureCard, actions, downloadErrorMessage, }) => {
    const controller = useRef(null);
    const [downloading, setDownloading] = useState(false);
    /** 下载进度百分比 */
    const [downloadPercent, setDownloadPercent] = useState(0);
    /** 显示下载按钮 */
    const showDownload = (file.url || "").indexOf("http") > -1;
    /** 显示下载进度条 */
    const showDownloadProgress = useMemo(() => !isPictureCard && downloading, [isPictureCard, downloading]);
    const UploadItem = isPictureCard ? UploadPictureItem : UploadFileItem;
    const UploadItemActions = isPictureCard
        ? UploadPictureItemActions
        : UploadFileItemActions;
    const handleDownload = () => __awaiter(void 0, void 0, void 0, function* () {
        var _a;
        if (!file.url)
            return;
        try {
            setDownloading(true);
            controller.current = new AbortController();
            const res = yield requestWithPercent({
                url: file.url,
                option: {
                    signal: (_a = controller.current) === null || _a === void 0 ? void 0 : _a.signal,
                },
                onProcess: (now, all) => {
                    setDownloadPercent(Math.round((now / all) * 100));
                },
            });
            // @ts-ignore
            const blob = new Blob([res]);
            const url = URL.createObjectURL(blob);
            const link = document.createElement("a");
            link.href = url;
            link.target = "_blank";
            link.download = file.name;
            link.style.display = "none";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
        catch (err) {
            if (err instanceof Error && err.name !== "AbortError") {
                message.error(downloadErrorMessage);
            }
        }
        finally {
            // 等待进度条动画完成
            setTimeout(() => {
                setDownloading(false);
                setDownloadPercent(0);
            }, 300);
        }
    });
    const handleDownloadCancel = () => {
        var _a;
        (_a = controller.current) === null || _a === void 0 ? void 0 : _a.abort();
    };
    return (_jsxs(UploadItem, { className: "dage-upload__item", "$showDownloadProgress": showDownloadProgress, children: [children, _jsxs(UploadItemActions, { className: "dage-upload__item__actions", children: [isPictureCard && (_jsx(Button, { type: "text", size: "small", icon: _jsx(EyeOutlined, {}), onClick: actions.preview })), showDownload && (_jsx(Button, { type: "text", size: "small", loading: downloading, disabled: downloading, icon: _jsx(DownloadOutlined, {}), onClick: handleDownload })), !disabled && (_jsx(Button, { type: "text", size: "small", icon: _jsx(DeleteOutlined, {}), onClick: actions.remove }))] }), showDownloadProgress && (_jsxs(DownloadProgress, { className: "dage-upload__item__progress", children: [_jsx(Progress, { size: "small", percent: downloadPercent, style: { margin: 0 } }), downloadPercent < 100 && (_jsx(DownloadCancelBtn, { onClick: handleDownloadCancel }))] }))] }));
};
