export const findNodeLevel = (nodes, targetKey, curLevel = 0) => {
    for (let node of nodes) {
        if (node.id === targetKey) {
            return curLevel;
        }
        if (node.children) {
            const childLevel = findNodeLevel(node.children, targetKey, curLevel + 1);
            if (childLevel !== -1) {
                return childLevel;
            }
        }
    }
    return -1;
};
export const findKeyPath = (nodes, targetKey, path = []) => {
    for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        const currentPath = [...path, i];
        if (node.id === targetKey) {
            return currentPath;
        }
        if (node.children) {
            const childPath = findKeyPath(node.children, targetKey, currentPath);
            if (childPath) {
                return childPath;
            }
        }
    }
    return null;
};
