import { __awaiter } from "tslib";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState } from "react";
import { Button, Modal } from "antd";
import { ExclamationCircleFilled } from "@ant-design/icons";
import { TreeTitle } from "./style";
import { findKeyPath, findNodeLevel } from "./utils";
const { confirm } = Modal;
export const DageTreeTitle = ({ data, maxLevel, treeData, onAdd, onEdit, onDelete, }) => {
    const [addLoading, setAddLoading] = useState(false);
    const [editLoading, setEditLoading] = useState(false);
    const handleAdd = (data) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            setAddLoading(true);
            yield (onAdd === null || onAdd === void 0 ? void 0 : onAdd(data, findKeyPath(treeData, data.id)));
        }
        finally {
            setAddLoading(false);
        }
    });
    const handleEdit = (data) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            setEditLoading(true);
            yield (onEdit === null || onEdit === void 0 ? void 0 : onEdit(data, findKeyPath(treeData, data.id)));
        }
        finally {
            setEditLoading(false);
        }
    });
    const handleDelete = (data) => {
        confirm({
            title: `提示`,
            icon: _jsx(ExclamationCircleFilled, {}),
            content: `确认是否删除 ${data.name} 节点`,
            okText: "确认",
            cancelText: "取消",
            onOk() {
                return onDelete === null || onDelete === void 0 ? void 0 : onDelete(data, findKeyPath(treeData, data.id));
            },
        });
    };
    return (_jsxs(TreeTitle, { children: [_jsx("p", { children: data.name }), _jsxs("div", { className: "dage-tree-title-toolbar", onClick: (e) => e.stopPropagation(), children: [Boolean(onAdd) &&
                        (!maxLevel || findNodeLevel(treeData, data.id) < maxLevel) &&
                        !data.hideAddBtn && (_jsx(Button, { type: "link", size: "small", loading: addLoading, onClick: handleAdd.bind(undefined, data), children: "\u65B0\u589E" })), Boolean(onEdit) && !data.hideEditBtn && (_jsx(Button, { type: "link", size: "small", loading: editLoading, color: "default", onClick: handleEdit.bind(undefined, data), children: "\u7F16\u8F91" })), Boolean(onDelete) && !data.hideDeleteBtn && (_jsx(Button, { type: "link", danger: true, size: "small", onClick: handleDelete.bind(undefined, data), children: "\u5220\u9664" }))] })] }));
};
