import { useAmap, usePlugins } from "@amap/amap-react";
import { memo, useEffect, useRef } from "react";
export const DageMapGeocoder = memo(({ city, position, onError, onChange }) => {
    const map = useAmap();
    const AMap = usePlugins(["AMap.Geocoder"]);
    const geocoder = useRef();
    useEffect(() => {
        if (!map || !AMap)
            return;
        // @ts-ignore
        geocoder.current = new AMap.Geocoder({
            city,
        });
        map.add(geocoder.current);
        return () => {
            map.remove(geocoder.current);
        };
    }, [map, AMap, city]);
    useEffect(() => {
        geocoder.current &&
            geocoder.current.getAddress(position, (status, result) => {
                if (status === "complete" && result.info === "OK") {
                    onChange === null || onChange === void 0 ? void 0 : onChange(result);
                }
                else {
                    onError === null || onError === void 0 ? void 0 : onError();
                }
            });
    }, [position, onChange]);
    return null;
}, (prevProps, nextProps) => prevProps.position[0] === nextProps.position[0] &&
    prevProps.position[1] === nextProps.position[1]);
