import { RuleObject } from "antd/es/form";
import { DageFileResponseType } from "../DageUpload";
export interface DageFileCheckboxMethods {
    /**
     * 校验已选类型文件是否为空
     */
    validate(rule: RuleObject, value: any, callback: (error?: string | undefined) => void): void;
    setFileList(list: DageFileResponseType[]): void;
}
export interface DageFileCheckboxProps {
    /**
     * 选中文件类型
     * @example model,video,audio
     */
    value?: string;
    /**
     * 上传的地址
     */
    action: string;
    /**
     * 是否禁用
     * @default false
     */
    disabled?: boolean;
    /**
     * 是否需要上传移动端模型
     * @default false
     */
    hasMobileModel?: boolean;
    /**
     * 最大上传PC端模型数量
     * @default 1
     */
    maxModelCount?: number;
    /**
     * 最大上传移动端模型数量
     * @default 1
     */
    maxMobileModelCount?: number;
    /**
     * 最大上传图片数量
     * @default 9
     */
    maxImgCount?: number;
    /**
     * 最大上传音频数量
     * @default 1
     */
    maxAudioCount?: number;
    /**
     * 最大上传视频数量
     * @default 1
     */
    maxVideoCount?: number;
    /**
     * 复选框变化时的回调
     */
    onChange?(v: string): void;
    /**
     * 上传文件改变时的回调
     */
    onFileChange?(list: DageFileResponseType[]): void;
}
//# sourceMappingURL=types.d.ts.map