import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Checkbox } from "antd";
import { forwardRef, useCallback, useEffect, useImperativeHandle, useMemo, useState, } from "react";
import { DAGE_FILE_CHECKBOX_OPTIONS } from "./constants";
import { DageUpload, DageUploadType, } from "../DageUpload";
import { FileCheckboxItem } from "./style";
export const DageFileCheckbox = forwardRef(({ value, action, disabled, hasMobileModel, maxAudioCount = 1, maxImgCount = 9, maxMobileModelCount = 1, maxModelCount = 1, maxVideoCount = 1, onChange, onFileChange, }, ref) => {
    const checkboxVal = useMemo(() => (value ? value.split(",") : []), [value]);
    const [modelFiles, setModelFiles] = useState([]);
    const [mobileModelFiles, setMobileModelFiles] = useState([]);
    const [imgFiles, setImgFiles] = useState([]);
    const [videoFiles, setVideoFiles] = useState([]);
    const [audioFiles, setAudioFiles] = useState([]);
    const hasModel = useMemo(() => checkboxVal.includes(DageUploadType.MODEL), [checkboxVal]);
    const hasImg = useMemo(() => checkboxVal.includes(DageUploadType.IMG), [checkboxVal]);
    const hasAudio = useMemo(() => checkboxVal.includes(DageUploadType.AUDIO), [checkboxVal]);
    const hasVideo = useMemo(() => checkboxVal.includes(DageUploadType.VIDEO), [checkboxVal]);
    useImperativeHandle(ref, () => ({
        validate(rule, val, callback) {
            if (!val) {
                callback("请选择文件类型");
            }
            else if (hasModel &&
                (!modelFiles.length || !modelFiles.some((i) => i.status === "done"))) {
                callback("PC端模型文件不能为空");
            }
            else if (hasModel &&
                hasMobileModel &&
                (!mobileModelFiles.length ||
                    !mobileModelFiles.some((i) => i.status === "done"))) {
                callback("移动端模型文件不能为空");
            }
            else if (hasImg &&
                (!imgFiles.length || !imgFiles.some((i) => i.status === "done"))) {
                callback("图片文件不能为空");
            }
            else if (hasVideo &&
                (!videoFiles.length || !videoFiles.some((i) => i.status === "done"))) {
                callback("视频文件不能为空");
            }
            else if (hasAudio &&
                (!audioFiles.length || !audioFiles.some((i) => i.status === "done"))) {
                callback("音频文件不能为空");
            }
            callback();
        },
        setFileList(list) {
            const stack = {
                [DageUploadType.MODEL]: [],
                [DageUploadType.MOBILE_MODEL]: [],
                [DageUploadType.IMG]: [],
                [DageUploadType.AUDIO]: [],
                [DageUploadType.VIDEO]: [],
            };
            list.forEach((item) => {
                stack[item.dType].push(item);
            });
            Object.keys(stack).forEach((key) => {
                const list = stack[key];
                if (!list.length)
                    return;
                switch (key) {
                    case DageUploadType.MODEL:
                        setModelFiles(list);
                        break;
                    case DageUploadType.MOBILE_MODEL:
                        setMobileModelFiles(list);
                        break;
                    case DageUploadType.IMG:
                        setImgFiles(list);
                        break;
                    case DageUploadType.AUDIO:
                        setAudioFiles(list);
                        break;
                    case DageUploadType.VIDEO:
                        setVideoFiles(list);
                        break;
                }
            });
        },
    }));
    const handleCheckbox = useCallback((val) => {
        onChange === null || onChange === void 0 ? void 0 : onChange(val.join(","));
    }, [onChange]);
    const handleFileChange = useCallback((method, list) => {
        method(list);
    }, []);
    useEffect(() => {
        if (!onFileChange)
            return;
        onFileChange([
            ...(hasModel ? modelFiles : []),
            ...(hasModel && hasMobileModel ? mobileModelFiles : []),
            ...(hasImg ? imgFiles : []),
            ...(hasVideo ? videoFiles : []),
            ...(hasAudio ? audioFiles : []),
        ]);
    }, [
        hasMobileModel,
        modelFiles,
        mobileModelFiles,
        imgFiles,
        videoFiles,
        audioFiles,
        hasModel,
        hasImg,
        hasVideo,
        hasAudio,
        onFileChange,
    ]);
    return (_jsxs("div", { className: "dage-file-checkbox", children: [_jsx(Checkbox.Group, { disabled: disabled, value: checkboxVal, options: DAGE_FILE_CHECKBOX_OPTIONS, style: {
                    display: "flex",
                    alignItems: "center",
                    height: "32px",
                }, onChange: handleCheckbox }), hasModel && (_jsxs(_Fragment, { children: [_jsxs(FileCheckboxItem, { className: "dage-file-checkbox__item", children: [_jsx("p", { children: "PC\u7AEF\u6A21\u578B\uFF1A" }), _jsx(DageUpload, { disabled: disabled, value: modelFiles, action: action, dType: DageUploadType.MODEL, maxCount: maxModelCount, maxSize: 500, tips: "\u4EC5\u652F\u63014dage\u683C\u5F0F\u7684\u6A21\u578B\u6587\u4EF6\uFF0C\u5927\u5C0F\u4E0D\u80FD\u8D85\u8FC7500M", onChange: handleFileChange.bind(undefined, setModelFiles) })] }), hasMobileModel && (_jsxs(FileCheckboxItem, { className: "dage-file-checkbox__item", children: [_jsx("p", { children: "\u79FB\u52A8\u7AEF\u6A21\u578B\uFF1A" }), _jsx(DageUpload, { disabled: disabled, value: mobileModelFiles, action: action, dType: DageUploadType.MOBILE_MODEL, maxCount: maxMobileModelCount, maxSize: 1000, tips: "\u4EC5\u652F\u6301zip\u683C\u5F0F\u7684\u538B\u7F29\u5305\uFF0C\u5927\u5C0F\u4E0D\u80FD\u8D85\u8FC71000M", onChange: handleFileChange.bind(undefined, setMobileModelFiles) })] }))] })), hasImg && (_jsxs(FileCheckboxItem, { className: "dage-file-checkbox__item", children: [_jsx("p", { children: "\u56FE\u7247\uFF1A" }), _jsx(DageUpload, { disabled: disabled, value: imgFiles, action: action, dType: DageUploadType.IMG, maxCount: maxImgCount, maxSize: 20, tips: "\u652F\u6301png\u3001jpg\u548Cjpeg\u683C\u5F0F\uFF1B\u6700\u592720M\uFF0C\u6700\u591A9\u5F20", onChange: handleFileChange.bind(undefined, setImgFiles) })] })), hasAudio && (_jsxs(FileCheckboxItem, { className: "dage-file-checkbox__item", children: [_jsx("p", { children: "\u97F3\u9891\uFF1A" }), _jsx(DageUpload, { disabled: disabled, value: audioFiles, action: action, dType: DageUploadType.AUDIO, maxCount: maxAudioCount, maxSize: 10, tips: "\u4EC5\u652F\u6301MP3\u683C\u5F0F\u7684\u97F3\u9891\u6587\u4EF6\uFF0C\u5927\u5C0F\u4E0D\u5F97\u8D85\u8FC710MB", onChange: handleFileChange.bind(undefined, setAudioFiles) })] })), hasVideo && (_jsxs(FileCheckboxItem, { className: "dage-file-checkbox__item", children: [_jsx("p", { children: "\u89C6\u9891\uFF1A" }), _jsx(DageUpload, { disabled: disabled, value: videoFiles, action: action, dType: DageUploadType.VIDEO, maxCount: maxVideoCount, maxSize: 500, tips: "\u4EC5\u652F\u6301MP4\u683C\u5F0F\u7684\u89C6\u9891\u6587\u4EF6\uFF0C\u5927\u5C0F\u4E0D\u5F97\u8D85\u8FC7500MB", onChange: handleFileChange.bind(undefined, setVideoFiles) })] }))] }));
});
export * from "./types";
export * from "./constants";
