import { IDomEditor, IToolbarConfig } from "@wangeditor/editor";
import { CSSProperties } from "react";
export interface DageEditorProps extends Partial<IToolbarConfig> {
    style?: CSSProperties;
    className?: string;
    value?: string;
    /**
     * @default 请输入内容
     */
    placeholder?: string;
    /**
     * 只读
     */
    readOnly?: boolean;
    /**
     * 文件上传地址
     */
    action: string;
    /**
     * form-data fieldName
     * @default file
     */
    fieldName?: string;
    /**
     * 单个图片的最大体积限制，单位 M
     * @default 2
     */
    maxImgSize?: number;
    /**
     * 单个视频的最大体积限制，单位 M
     * @default 100
     */
    maxVideoSize?: number;
    /**
     * 编辑器创建完毕时的回调函数
     */
    onCreated?(editor: IDomEditor): void;
    /**
     * 编辑器销毁时的回调函数
     */
    onDestroyed?(editor: IDomEditor): void;
    /**
     * 编辑器 focus 时的回调函数
     */
    onFocus?(editor: IDomEditor): void;
    /**
     * 编辑器 blur 时的回调函数
     */
    onBlur?(editor: IDomEditor): void;
    /**
     * 自定义粘贴。可阻止编辑器的默认粘贴，实现自己的粘贴逻辑
     */
    customPaste?(editor: IDomEditor, event: ClipboardEvent): boolean;
    onChange?(v: string): void;
}
export type InsertFnType = (url: string, alt: string, href: string) => void;
//# sourceMappingURL=types.d.ts.map