import { TableProps } from "antd";
import { ReactElement } from "react";
export interface DageEditableProps<T> extends Omit<TableProps<T>, "components" | "rowClassName" | "columns"> {
    defaultColumns: DageDefaultColumnTypes<T>[];
    handleSave: (row: T) => void;
}
export interface DageEditableRowProps {
    index: number;
}
export type DageCustomColumnTypes = {
    dataIndex: string;
    /**
     * 是否可以编辑
     */
    editable?: boolean;
    /**
     * 输入框
     * @default Input
     */
    Input?: ReactElement;
};
export interface DageEditableCellProps<T> extends Omit<DageCustomColumnTypes, "Input"> {
    title: React.ReactNode;
    record: T;
    Input: ReactElement;
    handleSave: (record: T) => void;
}
export type DageColumnTypes<T> = Exclude<TableProps<T>["columns"], undefined>;
export type DageDefaultColumnTypes<T> = DageColumnTypes<T>[number] & DageCustomColumnTypes;
//# sourceMappingURL=types.d.ts.map