import { __awaiter, __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { cloneElement, useContext, useEffect, useRef, useState, } from "react";
import { Form } from "antd";
import { DageEditableContext } from "./context";
import { EditableCellValueWrap } from "./style";
export const DageEditableCell = (_a) => {
    var { title, editable, children, dataIndex, record, Input, handleSave } = _a, restProps = __rest(_a, ["title", "editable", "children", "dataIndex", "record", "Input", "handleSave"]);
    // 防止首次触发校验
    const firstRender = useRef(true);
    const [editing, setEditing] = useState(Boolean(editable && Array.isArray(children) && !children[1]));
    const inputRef = useRef(null);
    const form = useContext(DageEditableContext);
    useEffect(() => {
        var _a;
        if (firstRender.current) {
            firstRender.current = false;
            return;
        }
        if (editing) {
            (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [editing]);
    const toggleEdit = () => {
        setEditing(!editing);
        form.setFieldsValue({ [dataIndex]: record[dataIndex] });
    };
    const save = () => __awaiter(void 0, void 0, void 0, function* () {
        const values = yield form.validateFields();
        toggleEdit();
        handleSave(Object.assign(Object.assign({}, record), values));
    });
    let childNode = children;
    if (editable) {
        childNode = editing ? (_jsx(Form.Item, { style: { margin: 0 }, 
            // @ts-ignore
            name: dataIndex, rules: [{ required: true, message: `请填写${title}` }], children: cloneElement(Input, {
                ref: inputRef,
                onPressEnter: save,
                onBlur: save,
            }) })) : (_jsx(EditableCellValueWrap, { style: { paddingInlineEnd: 24 }, onClick: toggleEdit, children: children }));
    }
    return _jsx("td", Object.assign({}, restProps, { children: childNode }));
};
