import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { Checkbox } from "antd";
import { isNumber, isObject, merge } from "lodash";
import { useEffect, useState } from "react";
export const DageCheckboxGroup = (_a) => {
    var { options, max } = _a, rest = __rest(_a, ["options", "max"]);
    const [_options, _setOptions] = useState([]);
    useEffect(() => {
        _setOptions(merge([], options === null || options === void 0 ? void 0 : options.map((i) => {
            if (isObject(i))
                return i;
            return {
                label: i,
                value: i,
            };
        }), _options));
    }, [options]);
    useEffect(() => {
        const { value } = rest;
        if (!value || !isNumber(max))
            return;
        _setOptions((val) => {
            return val.map((i) => (Object.assign(Object.assign({}, i), { disabled: value.length >= max ? !value.includes(i.value) : false })));
        });
    }, [rest.value, max]);
    return _jsx(Checkbox.Group, Object.assign({ options: _options }, rest));
};
